capture log close

global XVAR log_hy log_hnetw i.dm_age_years i.dm_gender i.em_mainjob_type i.parttime ///
	i.dm_education i.dm_citizen i.dm_ghealth i.dm_marstatus2 i.dm_hsize2 i.tempo i.country

log using reforms.smcl, replace

insheet using "$input_ext/macrovars.csv", clear delimiter("$DELIMITER")
reshape long unemprate gdphead intrate centgovdebt netlend, i(country) j(anno) 
ren anno int_year
sort country int_year
save macrovars, replace

insheet using "$input_ext/google_search.csv", clear delimiter(",")
egen country_23=rowmean(country_23_french country_23_dutch)
egen country_20=rowmean(country_20_french country_20_german)
drop country_23_french country_23_dutch country_23_german country_20_french country_20_german country_20_italian
reshape long country_, i(int_year int_month) j(country)
ren country_ google
g tempo=ym(int_year,int_month)
xtset country tempo
g google6=(google+l.google+l2.google+l3.google+l4.google+l5.google)/6
g google12=(google+l.google+l2.google+l3.google+l4.google+l5.google+l6.google+l7.google+l8.google+l9.google+l10.google+l11.google)/12
drop tempo
sort country int_year int_month
save google_search, replace

insheet using "$input_ext/google_austerity.csv", clear delimiter("$DELIMITER")
egen country_23=rowmean(country_23_french country_23_dutch)
egen country_20=rowmean(country_20_french country_20_german)
drop country_23_french country_23_dutch country_23_german country_20_french country_20_german country_20_italian
reshape long country_, i(int_year int_month) j(country)
ren country_ austerity
g tempo=ym(int_year,int_month)
xtset country tempo
g austerity6=(austerity+l.austerity+l2.austerity+l3.austerity+l4.austerity+l5.austerity)/6
g austerity12=(austerity+l.austerity+l2.austerity+l3.austerity+l4.austerity+l5.austerity+l6.austerity+l7.austerity+l8.austerity+l9.austerity+l10.austerity+l11.austerity)/12
drop tempo
sort country int_year int_month
save google_austerity, replace

insheet using "$input_ext/google_other_reforms.csv", clear delimiter("$DELIMITER")
egen country_23=rowmean(country_23_french country_23_dutch)
egen country_20=rowmean(country_20_french country_20_german)
drop country_23_french country_23_dutch country_23_german country_20_french country_20_german country_20_italian
reshape long country_, i(int_year int_month) j(country)
ren country_ other_reforms
g tempo=ym(int_year,int_month)
xtset country tempo
g other_reforms6=(other_reforms+l.other_reforms+l2.other_reforms+l3.other_reforms+l4.other_reforms+l5.other_reforms)/6
g other_reforms12=(other_reforms+l.other_reforms+l2.other_reforms+l3.other_reforms+l4.other_reforms+l5.other_reforms+l6.other_reforms+l7.other_reforms+l8.other_reforms+l9.other_reforms+l10.other_reforms+l11.other_reforms)/12
drop tempo
sort country int_year int_month
save google_other_reforms, replace

import excel "$input_ext/World_bank_internet_access_over_time.xlsx", sheet("Data_BE") firstrow clear
keep country year*
reshape long year, j(int_year) i(country)
ren year internet_access_pctpop
sort country int_year
save internet_access, replace

* IN THIS PART WE NEED TO DO THE FOLLOWING SELECTION
use complete_selected, clear

tab wave if ex_gov_red_pen!=. & ex_gov_age_incr!=.

* We keep only those between 50 and 65
keep if dm_age_years>=50 & dm_age_years<65

tab wave if ex_gov_red_pen!=. & ex_gov_age_incr!=.

count 

tab dm_gender em_employment

* Only employed 
keep if em_employment==2

count if wave!=6
tab wave if ex_gov_red_pen!=. & ex_gov_age_incr!=.

* I exclude Germany and Sweden, wave 4
drop if wave==4 & (country==12 | country==13)

count if wave!=6
tab wave if ex_gov_red_pen!=. & ex_gov_age_incr!=.

* I exclude Austria, Germany, Sweden, Netherlands, Spain and Switzerland wave 6
drop if (country==11 | country==12 | country==13 | country==14 | country==15 | country==20) & wave==6

count if wave!=6

* With no missing
drop if (orig_ex_gov_red_pen==. | orig_ex_gov_age_incr==.) & wave==4
drop if (orig_ex_gov_red_pen==. | orig_ex_gov_age_incr==.) & wave==6
drop if (orig_ex_gov_red_pen==. | orig_ex_gov_age_incr==.) & wave!=4 & wave!=6

count if wave!=6

drop if (orig_ex_gov_red_pen==.a | orig_ex_gov_age_incr==.a | orig_ex_gov_red_pen==.b | orig_ex_gov_age_incr==.b) & wave!=6
drop if (orig_ex_gov_red_pen==.a | orig_ex_gov_age_incr==.a | orig_ex_gov_red_pen==.b | orig_ex_gov_age_incr==.b) & wave==6

count if wave!=6

* The weights are generated by wave
sort country wave cl_age dm_gender
merge m:1 country wave cl_age dm_gender using weight_lfs
keep if _merge==3
drop _merge
g x=1
egen totsample=sum(x), by(country wave cl_age dm_gender)
g double pop_weight=totempl/totsample
sum pop_weight, d
egen double totempl_=sum(pop_weight), by(country wave cl_age dm_gender)
sum totempl totempl_
drop totempl_

/*
sort country dm_gender dm_age_years
merge m:1  country dm_gender dm_age_years using survival75
drop _merge

tab ex_expectancy, miss
* very few cases have the reference question different from 75, I exclude them
tab ex_expectancy_age, miss
replace ex_expectancy=. if ex_expectancy!=. & ex_expectancy!=.a & ex_expectancy!=.b & ex_expectancy_age!=75
g double _ex_expectancy=ex_expectancy/100
g miss_ex_expectancy=ex_expectancy==.a | ex_expectancy==.b
drop ex_expectancy
ren _ex_expectancy ex_expectancy
g double dif_ex_expectancy=ex_expectancy-survival
*/
sort country int_year int_month
merge m:1 country int_year int_month using google_search
drop if _merge==2
drop _merge

sort country int_year int_month
merge m:1 country int_year int_month using google_austerity
drop if _merge==2
drop _merge

sort country int_year int_month
merge m:1 country int_year int_month using google_other_reforms
drop if _merge==2
drop _merge

sort country int_year
merge m:1 country int_year using macrovars
drop if _merge==2
drop _merge

sort country int_year int_month
merge m:1 country int_year int_month using cabinet
drop if _merge==2
drop _merge

sort country int_year
merge m:1 country int_year using internet_access
drop if _merge==2
drop _merge

sort country int_year int_month
save descriptive, replace
	
*********************************************************
* REFORM EFFECT						*
*********************************************************

* ADD REFORM TO DATASET
insheet using "$input_ext/reforms_months.csv", clear delimiter("$DELIMITER")
tostring reform_*, replace
reshape long reform_a_ reform_b_, i(country country_l) j(year)
expand 12
bysort country year: g month=_n

g reform_age_incr=1 if month==1 & strpos(reform_a_, "January")!=0
replace reform_age_incr=1 if month==2 & strpos(reform_a_, "February")!=0
replace reform_age_incr=1 if month==3 & strpos(reform_a_, "March")!=0
replace reform_age_incr=1 if month==4 & strpos(reform_a_, "April")!=0
replace reform_age_incr=1 if month==5 & strpos(reform_a_, "May")!=0
replace reform_age_incr=1 if month==6 & strpos(reform_a_, "June")!=0
replace reform_age_incr=1 if month==7 & strpos(reform_a_, "July")!=0
replace reform_age_incr=1 if month==8 & strpos(reform_a_, "August")!=0
replace reform_age_incr=1 if month==9 & strpos(reform_a_, "September")!=0
replace reform_age_incr=1 if month==10 & strpos(reform_a_, "October")!=0
replace reform_age_incr=1 if month==11 & strpos(reform_a_, "November")!=0
replace reform_age_incr=1 if month==12 & strpos(reform_a_, "December")!=0
recode reform_age_incr .=0

g reform_red_pen=1 if month==1 & strpos(reform_b_, "January")!=0
replace reform_red_pen=1 if month==2 & strpos(reform_b_, "February")!=0
replace reform_red_pen=1 if month==3 & strpos(reform_b_, "March")!=0
replace reform_red_pen=1 if month==4 & strpos(reform_b_, "April")!=0
replace reform_red_pen=1 if month==5 & strpos(reform_b_, "May")!=0
replace reform_red_pen=1 if month==6 & strpos(reform_b_, "June")!=0
replace reform_red_pen=1 if month==7 & strpos(reform_b_, "July")!=0
replace reform_red_pen=1 if month==8 & strpos(reform_b_, "August")!=0
replace reform_red_pen=1 if month==9 & strpos(reform_b_, "September")!=0
replace reform_red_pen=1 if month==10 & strpos(reform_b_, "October")!=0
replace reform_red_pen=1 if month==11 & strpos(reform_b_, "November")!=0
replace reform_red_pen=1 if month==12 & strpos(reform_b_, "December")!=0
recode reform_red_pen .=0

g tempo=ym(year,month)

* reforms in previous 5 years
g sum_reform_age_incr = .
g sum_reform_red_pen = .

xtset country tempo

forval n = 516(1)671 {
         cap drop i`n'
         g i`n' = 1 if  `n'>tempo & (`n'-tempo) <= 60
         bysort country: egen sum_reform_age_incr`n' = total(reform_age_incr) if i`n'==1
         replace sum_reform_age_incr = l.sum_reform_age_incr`n' if tempo==`n'
         bysort country: egen sum_reform_red_pen`n' = total(reform_red_pen) if i`n'==1
         replace sum_reform_red_pen = l.sum_reform_red_pen`n' if tempo==`n'
         drop  i`n'
         drop sum_reform_age_incr`n'
         drop sum_reform_red_pen`n'
         }

xtset country tempo

g from_reform_age_incr=reform_age_incr==1
replace from_reform_age_incr=l.from_reform_age_incr+1 if reform_age_incr==0 & l.from_reform_age_incr!=0 & tempo>=457

g from_reform_red_pen=reform_red_pen==1
replace from_reform_red_pen=l.from_reform_red_pen+1 if reform_red_pen==0 & l.from_reform_red_pen!=0 & tempo>=457

sum tempo
g tempo2=-tempo+456+671

xtset country tempo2

g to_reform_age_incr=reform_age_incr==1
replace to_reform_age_incr=l.to_reform_age_incr+1 if reform_age_incr==0 & l.to_reform_age_incr!=0 & tempo2>=457

g to_reform_red_pen=reform_red_pen==1
replace to_reform_red_pen=l.to_reform_red_pen+1 if reform_red_pen==0 & l.to_reform_red_pen!=0 & tempo2>=457

xtset country tempo

* I build the inverse
g inv_to_reform_age_incr=to_reform_age_incr
g inv_from_reform_age_incr=from_reform_age_incr
g inv_to_reform_red_pen=to_reform_red_pen
g inv_from_reform_red_pen=from_reform_red_pen

replace inv_to_reform_age_incr=0 if inv_to_reform_age_incr>25
replace inv_from_reform_age_incr=0 if inv_from_reform_age_incr>25

replace inv_to_reform_red_pen=0 if inv_to_reform_red_pen>25
replace inv_from_reform_red_pen=0 if inv_from_reform_red_pen>25

replace inv_to_reform_age_incr=-inv_to_reform_age_incr+26 if inv_to_reform_age_incr!=0
replace inv_from_reform_age_incr=-inv_from_reform_age_incr+26 if inv_from_reform_age_incr!=0

replace inv_to_reform_red_pen=-inv_to_reform_red_pen+26 if inv_to_reform_red_pen!=0
replace inv_from_reform_red_pen=-inv_from_reform_red_pen+26 if inv_from_reform_red_pen!=0

* I build the inverse - 36 months
g inv_to_reform_age_incr36=to_reform_age_incr
g inv_from_reform_age_incr36=from_reform_age_incr
g inv_to_reform_red_pen36=to_reform_red_pen
g inv_from_reform_red_pen36=from_reform_red_pen

replace inv_to_reform_age_incr36=0 if inv_to_reform_age_incr36>37
replace inv_from_reform_age_incr36=0 if inv_from_reform_age_incr36>37

replace inv_to_reform_red_pen36=0 if inv_to_reform_red_pen36>37
replace inv_from_reform_red_pen36=0 if inv_from_reform_red_pen36>37

replace inv_to_reform_age_incr36=-inv_to_reform_age_incr36+38 if inv_to_reform_age_incr36!=0
replace inv_from_reform_age_incr36=-inv_from_reform_age_incr36+38 if inv_from_reform_age_incr36!=0

replace inv_to_reform_red_pen36=-inv_to_reform_red_pen36+38 if inv_to_reform_red_pen36!=0
replace inv_from_reform_red_pen36=-inv_from_reform_red_pen36+38 if inv_from_reform_red_pen36!=0

g g_country=10 if country==11 /*Austria*/
replace g_country=9 if country==23 /*Belgium*/
replace g_country=8 if country==18 /*Denmark*/
replace g_country=7 if country==17 /*France*/
replace g_country=6 if country==12 /*Germany*/
replace g_country=5 if country==16 /*Italy*/
replace g_country=4 if country==14 /*Netherlands*/
replace g_country=3 if country==15 /*Spain*/
replace g_country=2 if country==13 /*Sweden*/
replace g_country=1 if country==20 /*Switzerland*/

label define country2 10 "Austria" 9 "Belgium" 8 "Denmark" 7 "France" 6 "Germany" 5 "Italy" 4 "Netherlands" 3 "Spain" 2 "Sweden" 1 "Switzerland"
label value g_country country2

format tempo %tm
keep if year(dofm(tempo))>=2002

foreach vv in age_incr red_pen {
	if "`vv'"=="age_incr" {
		local color="blue"
		}
	else {
		local color="red"
		}
	egen D_to_reform_`vv'=rowmax(inv_to_reform_`vv' inv_from_reform_`vv')
	capture drop DD_to_reform_`vv'
	g DD_to_reform_`vv'=(g_country-1)*30+D_to_reform_`vv'
	graph twoway (line DD_to_reform_`vv' tempo if year(dofm(tempo))>=2002 & g_country==1, lcolor("`color'") lwidth(thick)) ///
		(line DD_to_reform_`vv' tempo if year(dofm(tempo))>=2002 & g_country==2, lcolor("`color'") lwidth(thick)) ///
		(line DD_to_reform_`vv' tempo if year(dofm(tempo))>=2002 & g_country==3, lcolor("`color'") lwidth(thick)) ///
		(line DD_to_reform_`vv' tempo if year(dofm(tempo))>=2002 & g_country==4, lcolor("`color'") lwidth(thick)) ///
		(line DD_to_reform_`vv' tempo if year(dofm(tempo))>=2002 & g_country==5, lcolor("`color'") lwidth(thick)) ///
		(line DD_to_reform_`vv' tempo if year(dofm(tempo))>=2002 & g_country==6, lcolor("`color'") lwidth(thick)) ///
		(line DD_to_reform_`vv' tempo if year(dofm(tempo))>=2002 & g_country==7, lcolor("`color'") lwidth(thick)) ///
		(line DD_to_reform_`vv' tempo if year(dofm(tempo))>=2002 & g_country==8, lcolor("`color'") lwidth(thick)) ///
		(line DD_to_reform_`vv' tempo if year(dofm(tempo))>=2002 & g_country==9, lcolor("`color'") lwidth(thick)) ///
		(line DD_to_reform_`vv' tempo if year(dofm(tempo))>=2002 & g_country==10, lcolor("`color'") lwidth(thick)), ///
		legend(off) ylabel(0 "Switzerland" 30 "Sweden" 60 "Spain" 90 "Netherlands" 120 "Italy" 150 "Germany" ///
		180 "France" 210 "Denmark" 240 "Belgium" 270 "Austria",  angle(0) labsize(medium)) yline(0(30)300, lcolor(gs12)) ytitle("") xtitle("") xlabel(,labsize(medium))
	graph export "$output/reforms_timeline_`vv'.eps", as(eps) replace
}
*
graph twoway (line inv_to_reform_age_incr tempo if year(dofm(tempo))>=2002 & g_country==1, lcolor(red)) ///
	(line inv_from_reform_age_incr tempo if year(dofm(tempo))>=2002 & g_country==1, lcolor(blue))

g ptr_to_age_incr=D_to_reform_age_incr if D_to_reform_age_incr==inv_to_reform_age_incr
replace ptr_to_age_incr=0 if D_to_reform_age_incr==25
g ptr_from_age_incr=D_to_reform_age_incr if D_to_reform_age_incr==inv_from_reform_age_incr
recode ptr_to_age_incr ptr_from_age_incr (.=0)
replace ptr_from_age_incr=ptr_from_age_incr/25
replace ptr_to_age_incr=ptr_to_age_incr/25

g ptr_to_red_pen=D_to_reform_red_pen if D_to_reform_red_pen==inv_to_reform_red_pen
replace ptr_to_red_pen=0 if D_to_reform_red_pen==25
g ptr_from_red_pen=D_to_reform_red_pen if D_to_reform_red_pen==inv_from_reform_red_pen
recode ptr_to_red_pen ptr_from_red_pen (.=0)
replace ptr_from_red_pen=ptr_from_red_pen/25
replace ptr_to_red_pen=ptr_to_red_pen/25

graph twoway (line ptr_to_age_incr tempo if year(dofm(tempo))>=2002 & g_country==1, lcolor(red)) ///
	(line ptr_from_age_incr tempo if year(dofm(tempo))>=2002 & g_country==1, lcolor(blue))

foreach vv in age_incr red_pen {
	if "`vv'"=="age_incr" {
		local color1="blue"
		local color2="green"
		}
	else {
		local color1="red"
		local color2="orange"
		}
	capture drop Pptr_to_`vv'
	g Pptr_to_`vv'=(g_country-1)*1.2+ptr_to_`vv'
	capture drop Pptr_from_`vv'
	g Pptr_from_`vv'=(g_country-1)*1.2+ptr_from_`vv'
	
	graph twoway (line Pptr_to_`vv' tempo if year(dofm(tempo))>=2002 & g_country==1, lcolor("`color1'") lwidth(thick)) (line Pptr_from_`vv' tempo if year(dofm(tempo))>=2002 & g_country==1, lcolor("`color2'") lwidth(thick) lpattern(dash)) ///
		(line Pptr_to_`vv' tempo if year(dofm(tempo))>=2002 & g_country==2, lcolor("`color1'") lwidth(thick)) (line Pptr_from_`vv' tempo if year(dofm(tempo))>=2002 & g_country==2, lcolor("`color2'") lwidth(thick) lpattern(dash)) ///
		(line Pptr_to_`vv' tempo if year(dofm(tempo))>=2002 & g_country==3, lcolor("`color1'") lwidth(thick)) (line Pptr_from_`vv' tempo if year(dofm(tempo))>=2002 & g_country==3, lcolor("`color2'") lwidth(thick) lpattern(dash)) ///
		(line Pptr_to_`vv' tempo if year(dofm(tempo))>=2002 & g_country==4, lcolor("`color1'") lwidth(thick)) (line Pptr_from_`vv' tempo if year(dofm(tempo))>=2002 & g_country==4, lcolor("`color2'") lwidth(thick) lpattern(dash)) ///
		(line Pptr_to_`vv' tempo if year(dofm(tempo))>=2002 & g_country==5, lcolor("`color1'") lwidth(thick)) (line Pptr_from_`vv' tempo if year(dofm(tempo))>=2002 & g_country==5, lcolor("`color2'") lwidth(thick) lpattern(dash)) ///
		(line Pptr_to_`vv' tempo if year(dofm(tempo))>=2002 & g_country==6, lcolor("`color1'") lwidth(thick)) (line Pptr_from_`vv' tempo if year(dofm(tempo))>=2002 & g_country==6, lcolor("`color2'") lwidth(thick) lpattern(dash)) ///
		(line Pptr_to_`vv' tempo if year(dofm(tempo))>=2002 & g_country==7, lcolor("`color1'") lwidth(thick)) (line Pptr_from_`vv' tempo if year(dofm(tempo))>=2002 & g_country==7, lcolor("`color2'") lwidth(thick) lpattern(dash)) ///
		(line Pptr_to_`vv' tempo if year(dofm(tempo))>=2002 & g_country==8, lcolor("`color1'") lwidth(thick)) (line Pptr_from_`vv' tempo if year(dofm(tempo))>=2002 & g_country==8, lcolor("`color2'") lwidth(thick) lpattern(dash)) ///
		(line Pptr_to_`vv' tempo if year(dofm(tempo))>=2002 & g_country==9, lcolor("`color1'") lwidth(thick)) (line Pptr_from_`vv' tempo if year(dofm(tempo))>=2002 & g_country==9, lcolor("`color2'") lwidth(thick) lpattern(dash)) ///
		(line Pptr_to_`vv' tempo if year(dofm(tempo))>=2002 & g_country==10, lcolor("`color1'") lwidth(thick)) (line Pptr_from_`vv' tempo if year(dofm(tempo))>=2002 & g_country==10, lcolor("`color2'") lwidth(thick) lpattern(dash)) , ///
		legend(order(1 "PtR(before)" 2 "PtR(after)")) ylabel(0 "Switzerland" 1.2 "Sweden" 2.4 "Spain" 3.6 "Netherlands" 4.8 "Italy" 6 "Germany" ///
		7.2 "France" 8.4 "Denmark" 9.6 "Belgium" 10.8 "Austria", angle(0) labsize(medium)) yline(0(1.2)10.8, lcolor(gs12)) ytitle("") xtitle("") xlabel(,labsize(medium))
	graph export "$output/reforms_timeline_`vv'_ptr.eps", as(eps) replace
	graph export "$output/reforms_timeline_`vv'_ptr.pdf", as(pdf) replace
}


egen D_to_reform_age_incr36=rowmax(inv_to_reform_age_incr36 inv_from_reform_age_incr36)
egen D_to_reform_red_pen36=rowmax(inv_to_reform_red_pen36 inv_from_reform_red_pen36)

sort country tempo

g select_age=(inv_to_reform_age_incr==25 & inv_from_reform_age_incr==25) | (inv_to_reform_age_incr>=12 & inv_from_reform_age_incr<12) ///
	| (inv_to_reform_age_incr<12 & inv_from_reform_age_incr>=12)

g select_pen=(inv_to_reform_red_pen==25 & inv_from_reform_red_pen==25) | (inv_to_reform_red_pen>=12 & inv_from_reform_red_pen<12) ///
	| (inv_to_reform_red_pen<12 & inv_from_reform_red_pen>=12)
	
	
keep country year month reform_red_pen reform_age_incr from* to* inv* select_* tempo D_* sum_reform_age_incr sum_reform_red_pen ptr*
ren year int_year
ren month int_month
sort country int_year int_month
save reform, replace

* block of distances
use descriptive, clear

tab int_year
capture drop _merge
* 2004 2005 2006 2007 2011 2013
sort country int_year int_month
merge m:1 country int_year int_month using reform
keep if _merge==3
drop _merge
sort country int_year

drop if int_year>2013

egen gruppo=group(country int_year int_month)

xi: ivreg2 ex_gov_age_incr $XVAR, cluster(gruppo) partial(i.tempo)
tab inv_to_reform_age_incr if e(sample)==1
tab inv_from_reform_age_incr if e(sample)==1
tab inv_to_reform_red_pen if e(sample)==1
tab inv_from_reform_red_pen if e(sample)==1
tab D_to_reform_age_incr if e(sample)==1
tab D_to_reform_red_pen if e(sample)==1

replace inv_from_reform_age_incr=0 if inv_to_reform_age_incr==25
replace inv_from_reform_red_pen=0 if inv_to_reform_red_pen==25

g time_reform_age_incr=0 if inv_to_reform_age_incr==0 & inv_from_reform_age_incr==0
replace time_reform_age_incr=1 if inv_to_reform_age_incr>12 & inv_to_reform_age_incr<=18 & D_to_reform_age_incr==inv_to_reform_age_incr
replace time_reform_age_incr=2 if inv_to_reform_age_incr>18 & inv_to_reform_age_incr<25 & D_to_reform_age_incr==inv_to_reform_age_incr
replace time_reform_age_incr=3 if inv_to_reform_age_incr==25 & D_to_reform_age_incr==inv_to_reform_age_incr
replace time_reform_age_incr=3 if inv_from_reform_age_incr<25 & inv_from_reform_age_incr>18 & D_to_reform_age_incr==inv_from_reform_age_incr
replace time_reform_age_incr=4 if inv_from_reform_age_incr<=18 & inv_from_reform_age_incr>12 & D_to_reform_age_incr==inv_from_reform_age_incr
recode time_reform_age_incr .=0

g time_reform_red_pen=0 if inv_to_reform_red_pen==0 & inv_from_reform_red_pen==0
replace time_reform_red_pen=1 if inv_to_reform_red_pen>12 & inv_to_reform_red_pen<=18 & D_to_reform_red_pen==inv_to_reform_red_pen
replace time_reform_red_pen=2 if inv_to_reform_red_pen>18 & inv_to_reform_red_pen<25 & D_to_reform_red_pen==inv_to_reform_red_pen
replace time_reform_red_pen=3 if inv_to_reform_red_pen==25 & D_to_reform_red_pen==inv_to_reform_red_pen
replace time_reform_red_pen=3 if inv_from_reform_red_pen<25 & inv_from_reform_red_pen>18 & D_to_reform_red_pen==inv_from_reform_red_pen
replace time_reform_red_pen=4 if inv_from_reform_red_pen<=18 & inv_from_reform_red_pen>12 & D_to_reform_red_pen==inv_from_reform_red_pen
recode time_reform_red_pen .=0

g dummy6PRE_reform_age_incr=time_reform_age_incr==2
g dummy6POST_reform_age_incr=time_reform_age_incr==3

g dummy6PRE_reform_red_pen=time_reform_red_pen==2
g dummy6POST_reform_red_pen=time_reform_red_pen==3

g timeS_reform_age_incr=0 if inv_to_reform_age_incr==0 & inv_from_reform_age_incr==0
replace timeS_reform_age_incr=1 if inv_to_reform_age_incr>12 & inv_to_reform_age_incr<25 & D_to_reform_age_incr==inv_to_reform_age_incr
replace timeS_reform_age_incr=2 if inv_to_reform_age_incr==25 & D_to_reform_age_incr==inv_to_reform_age_incr
replace timeS_reform_age_incr=2 if inv_from_reform_age_incr<25 & inv_from_reform_age_incr>12 & D_to_reform_age_incr==inv_from_reform_age_incr
recode timeS_reform_age_incr .=0

g timeS_reform_red_pen=0 if inv_to_reform_red_pen==0 & inv_from_reform_red_pen==0
replace timeS_reform_red_pen=1 if inv_to_reform_red_pen>12 & inv_to_reform_red_pen<25 & D_to_reform_red_pen==inv_to_reform_red_pen
replace timeS_reform_red_pen=2 if inv_to_reform_red_pen==25 & D_to_reform_red_pen==inv_to_reform_red_pen
replace timeS_reform_red_pen=2 if inv_from_reform_red_pen<25 & inv_from_reform_red_pen>12 & D_to_reform_red_pen==inv_from_reform_red_pen
recode timeS_reform_red_pen .=0

g timeS_reform_age_incrD18=(inv_to_reform_age_incr>6 & inv_to_reform_age_incr<25) & D_to_reform_age_incr==inv_to_reform_age_incr
replace timeS_reform_age_incrD18=0 if timeS_reform_age_incr==2
g timeS_reform_red_penD18=(inv_to_reform_red_pen>6 & inv_to_reform_red_pen<25) & D_to_reform_red_pen==inv_to_reform_red_pen
replace timeS_reform_red_penD18=0 if timeS_reform_red_pen==2

g timeS6_reform_age_incr=0 if inv_to_reform_age_incr==0 & inv_from_reform_age_incr==0
replace timeS6_reform_age_incr=1 if inv_to_reform_age_incr>18 & inv_to_reform_age_incr<25 & D_to_reform_age_incr==inv_to_reform_age_incr
replace timeS6_reform_age_incr=2 if inv_to_reform_age_incr==25 & D_to_reform_age_incr==inv_to_reform_age_incr
replace timeS6_reform_age_incr=2 if inv_from_reform_age_incr<25 & inv_from_reform_age_incr>18 & D_to_reform_age_incr==inv_from_reform_age_incr
recode timeS6_reform_age_incr .=0

g timeS6_reform_red_pen=0 if inv_to_reform_red_pen==0 & inv_from_reform_red_pen==0
replace timeS6_reform_red_pen=1 if inv_to_reform_red_pen>18 & inv_to_reform_red_pen<25 & D_to_reform_red_pen==inv_to_reform_red_pen
replace timeS6_reform_red_pen=2 if inv_to_reform_red_pen==25 & D_to_reform_red_pen==inv_to_reform_red_pen
replace timeS6_reform_red_pen=2 if inv_from_reform_red_pen<25 & inv_from_reform_red_pen>18 & D_to_reform_red_pen==inv_from_reform_red_pen
recode timeS6_reform_red_pen .=0

g timeS18_reform_age_incr=0 if inv_to_reform_age_incr==0 & inv_from_reform_age_incr==0
replace timeS18_reform_age_incr=1 if inv_to_reform_age_incr>6 & inv_to_reform_age_incr<25 & D_to_reform_age_incr==inv_to_reform_age_incr
replace timeS18_reform_age_incr=2 if inv_to_reform_age_incr==25 & D_to_reform_age_incr==inv_to_reform_age_incr
replace timeS18_reform_age_incr=2 if inv_from_reform_age_incr<25 & inv_from_reform_age_incr>6 & D_to_reform_age_incr==inv_from_reform_age_incr
recode timeS18_reform_age_incr .=0

g timeS18_reform_red_pen=0 if inv_to_reform_red_pen==0 & inv_from_reform_red_pen==0
replace timeS18_reform_red_pen=1 if inv_to_reform_red_pen>6 & inv_to_reform_red_pen<25 & D_to_reform_red_pen==inv_to_reform_red_pen
replace timeS18_reform_red_pen=2 if inv_to_reform_red_pen==25 & D_to_reform_red_pen==inv_to_reform_red_pen
replace timeS18_reform_red_pen=2 if inv_from_reform_red_pen<25 & inv_from_reform_red_pen>6 & D_to_reform_red_pen==inv_from_reform_red_pen
recode timeS18_reform_red_pen .=0

g timeS24_reform_age_incr=0 if inv_to_reform_age_incr==0 & inv_from_reform_age_incr==0
replace timeS24_reform_age_incr=1 if inv_to_reform_age_incr>0 & inv_to_reform_age_incr<25 & D_to_reform_age_incr==inv_to_reform_age_incr
replace timeS24_reform_age_incr=2 if inv_to_reform_age_incr==25 & D_to_reform_age_incr==inv_to_reform_age_incr
replace timeS24_reform_age_incr=2 if inv_from_reform_age_incr<25 & inv_from_reform_age_incr>0 & D_to_reform_age_incr==inv_from_reform_age_incr
recode timeS24_reform_age_incr .=0

g timeS24_reform_red_pen=0 if inv_to_reform_red_pen==0 & inv_from_reform_red_pen==0
replace timeS24_reform_red_pen=1 if inv_to_reform_red_pen>0 & inv_to_reform_red_pen<25 & D_to_reform_red_pen==inv_to_reform_red_pen
replace timeS24_reform_red_pen=2 if inv_to_reform_red_pen==25 & D_to_reform_red_pen==inv_to_reform_red_pen
replace timeS24_reform_red_pen=2 if inv_from_reform_red_pen<25 & inv_from_reform_red_pen>0 & D_to_reform_red_pen==inv_from_reform_red_pen
recode timeS24_reform_red_pen .=0

* 36 months
g timeS36_reform_age_incr=0 if inv_to_reform_age_incr36==0 & inv_from_reform_age_incr36==0
replace timeS36_reform_age_incr=1 if inv_to_reform_age_incr36>0 & inv_to_reform_age_incr36<37 & D_to_reform_age_incr36==inv_to_reform_age_incr36
replace timeS36_reform_age_incr=2 if inv_to_reform_age_incr36==37 & D_to_reform_age_incr36==inv_to_reform_age_incr36
replace timeS36_reform_age_incr=2 if inv_from_reform_age_incr36<37 & inv_from_reform_age_incr36>0 & D_to_reform_age_incr36==inv_from_reform_age_incr36
recode timeS36_reform_age_incr .=0

g timeS36_reform_red_pen=0 if inv_to_reform_red_pen36==0 & inv_from_reform_red_pen36==0
replace timeS36_reform_red_pen=1 if inv_to_reform_red_pen36>0 & inv_to_reform_red_pen36<37 & D_to_reform_red_pen36==inv_to_reform_red_pen36
replace timeS36_reform_red_pen=2 if inv_to_reform_red_pen36==37 & D_to_reform_red_pen36==inv_to_reform_red_pen36
replace timeS36_reform_red_pen=2 if inv_from_reform_red_pen36<37 & inv_from_reform_red_pen36>0 & D_to_reform_red_pen36==inv_from_reform_red_pen36
recode timeS36_reform_red_pen .=0

*alternative definitions
g timeS_reform_age_incrD1=(inv_to_reform_age_incr>12 & inv_to_reform_age_incr<25)
g timeS_reform_age_incrD2=inv_to_reform_age_incr==25 | (inv_from_reform_age_incr<25 & inv_from_reform_age_incr>12)

g timeS_reform_red_penD1=(inv_to_reform_red_pen>12 & inv_to_reform_red_pen<25)
g timeS_reform_red_penD2=inv_to_reform_red_pen==25 | (inv_from_reform_red_pen<25 & inv_from_reform_red_pen>12)

save reforms, replace

************************************************
* SAMPLE SELECTION

use reforms, clear
xi: ivreg2 ex_gov_age_incr $XVAR, cluster(gruppo) partial(i.tempo)
g c=e(sample)==1
collapse (sum) c, by(tempo)
tab c
sum c, d

use reforms, clear
xi: ivreg2 ex_gov_age_incr $XVAR, cluster(gruppo) partial(i.tempo)
g c=e(sample)==1
tab tempo country if c==1

use reforms, clear
xi: ivreg2 ex_gov_age_incr $XVAR, cluster(gruppo) partial(i.tempo)
g miss=e(sample)==0
table country int_year, c(mean miss)
*drop miss
drop if e(sample)==0
g c=e(sample)==1
egen tot=sum(c), by(country tempo)
count if tot<30
g samplesel=tot>=30
save reforms, replace

************************************************
* ANNOUNCEMENTS
* I add whether the reform was announced or not
* I do this manually
use reforms, clear
* First check: definition of timeS_reform_age_incr is consistent with the main table
table tempo country, c(mean timeS_reform_age_incr)
tab tempo country if timeS_reform_age_incr==1
capture drop tempo2
g tempo2=tempo
table tempo country if timeS_reform_age_incr==1, c(mean tempo2)

* 1 announced 2 not yet announced 3 after
g timeS_reform_age_incr_A=timeS_reform_age_incr
replace timeS_reform_age_incr_A=2 if timeS_reform_age_incr==1
replace timeS_reform_age_incr_A=3 if timeS_reform_age_incr==2

g timeSB_reform_age_incr_A=timeS_reform_age_incr
replace timeSB_reform_age_incr_A=2 if timeS_reform_age_incr==1
replace timeSB_reform_age_incr_A=3 if timeS_reform_age_incr==2

g timeS18D_reform_age_incr_A=timeS_reform_age_incr
replace timeS18D_reform_age_incr_A=2 if timeS_reform_age_incrD18==1
replace timeS18D_reform_age_incr_A=3 if timeS_reform_age_incr==2

g timeS18_reform_age_incr_A=timeS18_reform_age_incr
replace timeS18_reform_age_incr_A=2 if timeS18_reform_age_incr==1
replace timeS18_reform_age_incr_A=3 if timeS18_reform_age_incr==2

g timeS24_reform_age_incr_A=timeS24_reform_age_incr
replace timeS24_reform_age_incr_A=2 if timeS24_reform_age_incr==1
replace timeS24_reform_age_incr_A=3 if timeS24_reform_age_incr==2

g timeS6_reform_age_incr_A=timeS6_reform_age_incr
replace timeS6_reform_age_incr_A=2 if timeS6_reform_age_incr==1
replace timeS6_reform_age_incr_A=3 if timeS6_reform_age_incr==2

* 1 announced [12-7] 2 not yet announced [12-7] 3 announced [6-1] 4 not yet announced [6-1] 5 after [0-6] 6 after [7-12]
g time_reform_age_incr_A=time_reform_age_incr
replace time_reform_age_incr_A=2 if time_reform_age_incr==1
replace time_reform_age_incr_A=4 if time_reform_age_incr==2
replace time_reform_age_incr_A=5 if time_reform_age_incr==3
replace time_reform_age_incr_A=6 if time_reform_age_incr==4

foreach s in S S18D S18 S24 S6 {
	*Austria - 11
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==11 & tempo>=ym(2003,3) & tempo<ym(2003,6)
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==11 & tempo>=ym(2004,10) & tempo<ym(2004,12)
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==11 & tempo>=ym(2010,10) & tempo<ym(2010,12)
	*Belgium - 23
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==23 & tempo>=ym(2005,10) & tempo<ym(2005,12)
	*Denmark - 18
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==18 & tempo>=ym(2006,4) & tempo<ym(2006,6)
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==18 & tempo>=ym(2011,5) & tempo<ym(2011,12)
	*France - 17
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==17 & tempo>=ym(2003,1) & tempo<ym(2003,7)
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==17 & tempo>=ym(2010,6) & tempo<ym(2010,11)
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==17 & tempo>=ym(2011,11) & tempo<ym(2011,12)
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==17 & tempo>=ym(2013,9) & tempo<ym(2014,1)
	*Germany - 12
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==12 & tempo>=ym(2006,11) & tempo<ym(2007,3)
	*Italy - 16
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==16 & tempo>=ym(2004,1) & tempo<ym(2004,7)
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==16 & tempo>=ym(2008,11) & tempo<ym(2009,7)
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==16 & tempo>=ym(2010,6) & tempo<ym(2010,7)
	*Netherlands - 14
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==14 & tempo>=ym(2012,5) & tempo<ym(2012,7)
	*Spain - 15
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==15 & tempo>=ym(2006,7) & tempo<ym(2007,12)
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==15 & tempo>=ym(2011,1) & tempo<ym(2011,8)
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==15 & tempo>=ym(2013,10) & tempo<ym(2013,12)
	*Switzerland - 20
	replace time`s'_reform_age_incr_A=1 if time`s'_reform_age_incr_A==2 & country==20 & tempo>=ym(2000,2) & tempo<ym(2003,10)
}

foreach s in SB {
	*Austria - 11
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==11 & tempo>=ym(2003,3) & tempo<ym(2003,6)
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==11 & tempo>=ym(2004,10) & tempo<ym(2004,12)
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==11 & tempo>=ym(2010,10) & tempo<ym(2010,12)
	*Belgium - 23
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==23 & tempo>=ym(2005,10) & tempo<ym(2005,12)
	*Denmark - 18
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==18 & tempo>=ym(2006,4) & tempo<ym(2006,6)
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==18 & tempo>=ym(2011,5) & tempo<ym(2011,12)
	*France - 17
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==17 & tempo>=ym(2003,1) & tempo<ym(2003,7)
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==17 & tempo>=ym(2010,6) & tempo<ym(2010,11)
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==17 & tempo>=ym(2011,11) & tempo<ym(2011,12)
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==17 & tempo>=ym(2013,9) & tempo<ym(2014,1)
	*Germany - 12
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==12 & tempo>=ym(2006,11) & tempo<ym(2007,3)
	*Italy - 16
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==16 & tempo>=ym(2004,1) & tempo<ym(2004,7)
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==16 & tempo>=ym(2008,11) & tempo<ym(2009,7)
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==16 & tempo>=ym(2010,6) & tempo<ym(2010,7)
	*Netherlands - 14
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==14 & tempo>=ym(2012,5) & tempo<ym(2012,7)
	*Spain - 15
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==15 & tempo>=ym(2006,7) & tempo<ym(2007,12)
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==15 & tempo>=ym(2011,1) & tempo<ym(2011,8)
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==15 & tempo>=ym(2013,10) & tempo<ym(2013,12)
	*Switzerland - 20
	replace time`s'_reform_age_incr_A=time`s'_reform_age_incr_A+0.5 if country==20 & tempo>=ym(2000,2) & tempo<ym(2003,10)
}

	*Austria - 11
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==11 & tempo>=ym(2003,3) & tempo<ym(2003,6)
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==11 & tempo>=ym(2004,10) & tempo<ym(2004,12)
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==11 & tempo>=ym(2010,10) & tempo<ym(2010,12)
	*Belgium - 23
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==23 & tempo>=ym(2005,10) & tempo<ym(2005,12)
	*Denmark - 18
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==18 & tempo>=ym(2006,4) & tempo<ym(2006,6)
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==18 & tempo>=ym(2011,5) & tempo<ym(2011,12)
	*France - 17
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==17 & tempo>=ym(2003,1) & tempo<ym(2003,7)
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==17 & tempo>=ym(2010,6) & tempo<ym(2010,11)
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==17 & tempo>=ym(2011,11) & tempo<ym(2011,12)
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==17 & tempo>=ym(2013,9) & tempo<ym(2014,1)
	*Germany - 12
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==12 & tempo>=ym(2006,11) & tempo<ym(2007,3)
	*Italy - 16
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==16 & tempo>=ym(2004,1) & tempo<ym(2004,7)
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==16 & tempo>=ym(2008,11) & tempo<ym(2009,7)
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==16 & tempo>=ym(2010,6) & tempo<ym(2010,7)
	*Netherlands - 14
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==14 & tempo>=ym(2012,5) & tempo<ym(2012,7)
	*Spain - 15
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==15 & tempo>=ym(2006,7) & tempo<ym(2007,12)
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==15 & tempo>=ym(2011,1) & tempo<ym(2011,8)
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==15 & tempo>=ym(2013,10) & tempo<ym(2013,12)
	*Switzerland - 20
	replace time_reform_age_incr_A=1 if time_reform_age_incr_A==2 & country==20 & tempo>=ym(2000,2) & tempo<ym(2003,10)

	*Austria - 11
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==11 & tempo>=ym(2003,3) & tempo<ym(2003,6)
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==11 & tempo>=ym(2004,10) & tempo<ym(2004,12)
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==11 & tempo>=ym(2010,10) & tempo<ym(2010,12)
	*Belgium - 23
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==23 & tempo>=ym(2005,10) & tempo<ym(2005,12)
	*Denmark - 18
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==18 & tempo>=ym(2006,4) & tempo<ym(2006,6)
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==18 & tempo>=ym(2011,5) & tempo<ym(2011,12)
	*France - 17
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==17 & tempo>=ym(2003,1) & tempo<ym(2003,7)
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==17 & tempo>=ym(2010,6) & tempo<ym(2010,11)
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==17 & tempo>=ym(2011,11) & tempo<ym(2011,12)
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==17 & tempo>=ym(2013,9) & tempo<ym(2014,1)
	*Germany - 12
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==12 & tempo>=ym(2006,11) & tempo<ym(2007,3)
	*Italy - 16
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==16 & tempo>=ym(2004,1) & tempo<ym(2004,7)
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==16 & tempo>=ym(2008,11) & tempo<ym(2009,7)
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==16 & tempo>=ym(2010,6) & tempo<ym(2010,7)
	*Netherlands - 14
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==14 & tempo>=ym(2012,5) & tempo<ym(2012,7)
	*Spain - 15
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==15 & tempo>=ym(2006,7) & tempo<ym(2007,12)
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==15 & tempo>=ym(2011,1) & tempo<ym(2011,8)
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==15 & tempo>=ym(2013,10) & tempo<ym(2013,12)
	*Switzerland - 20
	replace time_reform_age_incr_A=3 if time_reform_age_incr_A==4 & country==20 & tempo>=ym(2000,2) & tempo<ym(2003,10)

	g dist_ann_age_incr=.
	*Austria - 11
	replace dist_ann_age_incr=tempo-ym(2003,3) if timeS_reform_age_incr_A==1 & country==11 & tempo>=ym(2003,3) & tempo<ym(2003,6)
	replace dist_ann_age_incr=tempo-ym(2004,10) if timeS_reform_age_incr_A==1 & country==11 & tempo>=ym(2004,10) & tempo<ym(2004,12)
	replace dist_ann_age_incr=tempo-ym(2010,10) if timeS_reform_age_incr_A==1 & country==11 & tempo>=ym(2010,10) & tempo<ym(2010,12)
	*Belgium - 23
	replace dist_ann_age_incr=tempo-ym(2005,10) if timeS_reform_age_incr_A==1 & country==23 & tempo>=ym(2005,10) & tempo<ym(2005,12)
	*Denmark - 18
	replace dist_ann_age_incr=tempo-ym(2006,4) if timeS_reform_age_incr_A==1 & country==18 & tempo>=ym(2006,4) & tempo<ym(2006,6)
	replace dist_ann_age_incr=tempo-ym(2011,5) if timeS_reform_age_incr_A==1 & country==18 & tempo>=ym(2011,5) & tempo<ym(2011,12)
	*France - 17
	replace dist_ann_age_incr=tempo-ym(2003,1) if timeS_reform_age_incr_A==1 & country==17 & tempo>=ym(2003,1) & tempo<ym(2003,7)
	replace dist_ann_age_incr=tempo-ym(2010,6) if timeS_reform_age_incr_A==1 & country==17 & tempo>=ym(2010,6) & tempo<ym(2010,11)
	replace dist_ann_age_incr=tempo-ym(2011,11) if timeS_reform_age_incr_A==1 & country==17 & tempo>=ym(2011,11) & tempo<ym(2011,12)
	replace dist_ann_age_incr=tempo-ym(2013,9) if timeS_reform_age_incr_A==1 & country==17 & tempo>=ym(2013,9) & tempo<ym(2014,1)
	*Germany - 12
	replace dist_ann_age_incr=tempo-ym(2006,11) if timeS_reform_age_incr_A==1 & country==12 & tempo>=ym(2006,11) & tempo<ym(2007,3)
	*Italy - 16
	replace dist_ann_age_incr=tempo-ym(2004,1) if timeS_reform_age_incr_A==1 & country==16 & tempo>=ym(2004,1) & tempo<ym(2004,7)
	replace dist_ann_age_incr=tempo-ym(2008,11) if timeS_reform_age_incr_A==1 & country==16 & tempo>=ym(2008,11) & tempo<ym(2009,7)
	replace dist_ann_age_incr=tempo-ym(2010,6) if timeS_reform_age_incr_A==1 & country==16 & tempo>=ym(2010,6) & tempo<ym(2010,7)
	*Netherlands - 14
	replace dist_ann_age_incr=tempo-ym(2012,5) if timeS_reform_age_incr_A==1 & country==14 & tempo>=ym(2012,5) & tempo<ym(2012,7)
	*Spain - 15
	replace dist_ann_age_incr=tempo-ym(2006,7) if timeS_reform_age_incr_A==1 & country==15 & tempo>=ym(2006,7) & tempo<ym(2007,12)
	replace dist_ann_age_incr=tempo-ym(2011,1) if timeS_reform_age_incr_A==1 & country==15 & tempo>=ym(2011,1) & tempo<ym(2011,8)
	replace dist_ann_age_incr=tempo-ym(2013,10) if timeS_reform_age_incr_A==1 & country==15 & tempo>=ym(2013,10) & tempo<ym(2013,12)
	*Switzerland - 20
	replace dist_ann_age_incr=tempo-ym(2000,2) if timeS_reform_age_incr_A==1 & country==20 & tempo>=ym(2000,2) & tempo<ym(2003,10)

table tempo country, c(mean timeS_reform_red_pen)
tab tempo country if timeS_reform_red_pen==1
table tempo country if timeS_reform_red_pen==1, c(mean tempo2)

g timeS_reform_red_pen_A=timeS_reform_red_pen
replace timeS_reform_red_pen_A=2 if timeS_reform_red_pen==1
replace timeS_reform_red_pen_A=3 if timeS_reform_red_pen==2

g timeSB_reform_red_pen_A=timeS_reform_red_pen
replace timeSB_reform_red_pen_A=2 if timeS_reform_red_pen==1
replace timeSB_reform_red_pen_A=3 if timeS_reform_red_pen==2

g timeS18D_reform_red_pen_A=timeS_reform_red_pen
replace timeS18D_reform_red_pen_A=2 if timeS_reform_red_penD18==1
replace timeS18D_reform_red_pen_A=3 if timeS_reform_red_pen==2

g timeS18_reform_red_pen_A=timeS18_reform_red_pen
replace timeS18_reform_red_pen_A=2 if timeS18_reform_red_pen==1
replace timeS18_reform_red_pen_A=3 if timeS18_reform_red_pen==2

g timeS24_reform_red_pen_A=timeS24_reform_red_pen
replace timeS24_reform_red_pen_A=2 if timeS24_reform_red_pen==1
replace timeS24_reform_red_pen_A=3 if timeS24_reform_red_pen==2

g timeS6_reform_red_pen_A=timeS6_reform_red_pen
replace timeS6_reform_red_pen_A=2 if timeS6_reform_red_pen==1
replace timeS6_reform_red_pen_A=3 if timeS6_reform_red_pen==2

* 1 announced [7-12] 2 not yet announced [7-12] 3 announced [0-6] 4 not yet announced [0-6] 5 after [0-6] 6 after [7-12]
g time_reform_red_pen_A=time_reform_red_pen
replace time_reform_red_pen_A=2 if time_reform_red_pen==1
replace time_reform_red_pen_A=4 if time_reform_red_pen==2
replace time_reform_red_pen_A=5 if time_reform_red_pen==3
replace time_reform_red_pen_A=6 if time_reform_red_pen==4

foreach s in S S18 S18D S24 S6 {
	*Austria - 11
	replace time`s'_reform_red_pen_A=1 if time`s'_reform_red_pen_A==2 & country==11 & tempo>=ym(2003,3) & tempo<ym(2003,6)
	replace time`s'_reform_red_pen_A=1 if time`s'_reform_red_pen_A==2 & country==11 & tempo>=ym(2004,10) & tempo<ym(2004,12)
	replace time`s'_reform_red_pen_A=1 if time`s'_reform_red_pen_A==2 & country==11 & tempo>=ym(2010,10) & tempo<ym(2010,12)
	*Denmark - 18
	replace time`s'_reform_red_pen_A=1 if time`s'_reform_red_pen_A==2 & country==18 & tempo>=ym(2011,5) & tempo<ym(2011,12)
	*France - 17
	replace time`s'_reform_red_pen_A=1 if time`s'_reform_red_pen_A==2 & country==17 & tempo>=ym(2003,1) & tempo<ym(2003,7)
	replace time`s'_reform_red_pen_A=1 if time`s'_reform_red_pen_A==2 & country==17 & tempo>=ym(2013,9) & tempo<ym(2014,1)
	*Germany - 12
	replace time`s'_reform_red_pen_A=1 if time`s'_reform_red_pen_A==2 & country==12 & tempo>=ym(2003,8) & tempo<ym(2004,6)
	*Italy - 16
	replace time`s'_reform_red_pen_A=1 if time`s'_reform_red_pen_A==2 & country==16 & tempo>=ym(2004,1) & tempo<ym(2004,7)
	*Spain - 15
	replace time`s'_reform_red_pen_A=1 if time`s'_reform_red_pen_A==2 & country==15 & tempo>=ym(2006,7) & tempo<ym(2007,12)
	replace time`s'_reform_red_pen_A=1 if time`s'_reform_red_pen_A==2 & country==15 & tempo>=ym(2011,1) & tempo<ym(2011,8)
	replace time`s'_reform_red_pen_A=1 if time`s'_reform_red_pen_A==2 & country==15 & tempo>=ym(2013,10) & tempo<ym(2013,12)
	*Switzerland - 20 (for the 2003,10 reform, composed by two different laws, there were two announcements, one in march 2000, the other in feb 2000)
	replace time`s'_reform_red_pen_A=1 if time`s'_reform_red_pen_A==2 & country==20 & tempo>=ym(2000,2) & tempo<ym(2003,10)
	replace time`s'_reform_red_pen_A=1 if time`s'_reform_red_pen_A==2 & country==20 & tempo>=ym(2006,1) & tempo<ym(2008,12)
}

foreach s in SB {
	*Austria - 11
	replace time`s'_reform_red_pen_A=time`s'_reform_red_pen_A+0.5 if country==11 & tempo>=ym(2003,3) & tempo<ym(2003,6)
	replace time`s'_reform_red_pen_A=time`s'_reform_red_pen_A+0.5 if country==11 & tempo>=ym(2004,10) & tempo<ym(2004,12)
	replace time`s'_reform_red_pen_A=time`s'_reform_red_pen_A+0.5 if country==11 & tempo>=ym(2010,10) & tempo<ym(2010,12)
	*Denmark - 18
	replace time`s'_reform_red_pen_A=time`s'_reform_red_pen_A+0.5 if country==18 & tempo>=ym(2011,5) & tempo<ym(2011,12)
	*France - 17
	replace time`s'_reform_red_pen_A=time`s'_reform_red_pen_A+0.5 if country==17 & tempo>=ym(2003,1) & tempo<ym(2003,7)
	replace time`s'_reform_red_pen_A=time`s'_reform_red_pen_A+0.5 if country==17 & tempo>=ym(2013,9) & tempo<ym(2014,1)
	*Germany - 12
	replace time`s'_reform_red_pen_A=time`s'_reform_red_pen_A+0.5 if country==12 & tempo>=ym(2003,8) & tempo<ym(2004,6)
	*Italy - 16
	replace time`s'_reform_red_pen_A=time`s'_reform_red_pen_A+0.5 if country==16 & tempo>=ym(2004,1) & tempo<ym(2004,7)
	*Spain - 15
	replace time`s'_reform_red_pen_A=time`s'_reform_red_pen_A+0.5 if country==15 & tempo>=ym(2006,7) & tempo<ym(2007,12)
	replace time`s'_reform_red_pen_A=time`s'_reform_red_pen_A+0.5 if country==15 & tempo>=ym(2011,1) & tempo<ym(2011,8)
	replace time`s'_reform_red_pen_A=time`s'_reform_red_pen_A+0.5 if country==15 & tempo>=ym(2013,10) & tempo<ym(2013,12)
	*Switzerland - 20 (for the 2003,10 reform, composed by two different laws, there were two announcements, one in march 2000, the other in feb 2000)
	replace time`s'_reform_red_pen_A=time`s'_reform_red_pen_A+0.5 if country==20 & tempo>=ym(2000,2) & tempo<ym(2003,10)
	replace time`s'_reform_red_pen_A=time`s'_reform_red_pen_A+0.5 if country==20 & tempo>=ym(2006,1) & tempo<ym(2008,12)
}

	*Austria - 11
	replace time_reform_red_pen_A=1 if time_reform_red_pen_A==2 & country==11 & tempo>=ym(2003,3) & tempo<ym(2003,6)
	replace time_reform_red_pen_A=1 if time_reform_red_pen_A==2 & country==11 & tempo>=ym(2004,10) & tempo<ym(2004,12)
	replace time_reform_red_pen_A=1 if time_reform_red_pen_A==2 & country==11 & tempo>=ym(2010,10) & tempo<ym(2010,12)
	*Denmark - 18
	replace time_reform_red_pen_A=1 if time_reform_red_pen_A==2 & country==18 & tempo>=ym(2011,5) & tempo<ym(2011,12)
	*France - 17
	replace time_reform_red_pen_A=1 if time_reform_red_pen_A==2 & country==17 & tempo>=ym(2003,1) & tempo<ym(2003,7)
	replace time_reform_red_pen_A=1 if time_reform_red_pen_A==2 & country==17 & tempo>=ym(2013,9) & tempo<ym(2014,1)
	*Germany - 12
	replace time_reform_red_pen_A=1 if time_reform_red_pen_A==2 & country==12 & tempo>=ym(2003,8) & tempo<ym(2004,6)
	*Italy - 16
	replace time_reform_red_pen_A=1 if time_reform_red_pen_A==2 & country==16 & tempo>=ym(2004,1) & tempo<ym(2004,7)
	*Spain - 15
	replace time_reform_red_pen_A=1 if time_reform_red_pen_A==2 & country==15 & tempo>=ym(2006,7) & tempo<ym(2007,12)
	replace time_reform_red_pen_A=1 if time_reform_red_pen_A==2 & country==15 & tempo>=ym(2011,1) & tempo<ym(2011,8)
	replace time_reform_red_pen_A=1 if time_reform_red_pen_A==2 & country==15 & tempo>=ym(2013,10) & tempo<ym(2013,12)
	*Switzerland - 20 (for the 2003,10 reform, composed by two different laws, there were two announcements, one in march 2000, the other in feb 2000)
	replace time_reform_red_pen_A=1 if time_reform_red_pen_A==2 & country==20 & tempo>=ym(2000,2) & tempo<ym(2003,10)
	replace time_reform_red_pen_A=1 if time_reform_red_pen_A==2 & country==20 & tempo>=ym(2006,1) & tempo<ym(2008,12)

	*Austria - 11
	replace time_reform_red_pen_A=3 if time_reform_red_pen_A==4 & country==11 & tempo>=ym(2003,3) & tempo<ym(2003,6)
	replace time_reform_red_pen_A=3 if time_reform_red_pen_A==4 & country==11 & tempo>=ym(2004,10) & tempo<ym(2004,12)
	replace time_reform_red_pen_A=3 if time_reform_red_pen_A==4 & country==11 & tempo>=ym(2010,10) & tempo<ym(2010,12)
	*Denmark - 18
	replace time_reform_red_pen_A=3 if time_reform_red_pen_A==4 & country==18 & tempo>=ym(2011,5) & tempo<ym(2011,12)
	*France - 17
	replace time_reform_red_pen_A=3 if time_reform_red_pen_A==4 & country==17 & tempo>=ym(2003,1) & tempo<ym(2003,7)
	replace time_reform_red_pen_A=3 if time_reform_red_pen_A==4 & country==17 & tempo>=ym(2013,9) & tempo<ym(2014,1)
	*Germany - 12
	replace time_reform_red_pen_A=3 if time_reform_red_pen_A==4 & country==12 & tempo>=ym(2003,8) & tempo<ym(2004,6)
	*Italy - 16
	replace time_reform_red_pen_A=3 if time_reform_red_pen_A==4 & country==16 & tempo>=ym(2004,1) & tempo<ym(2004,7)
	*Spain - 15
	replace time_reform_red_pen_A=3 if time_reform_red_pen_A==4 & country==15 & tempo>=ym(2006,7) & tempo<ym(2007,12)
	replace time_reform_red_pen_A=3 if time_reform_red_pen_A==4 & country==15 & tempo>=ym(2011,1) & tempo<ym(2011,8)
	replace time_reform_red_pen_A=3 if time_reform_red_pen_A==4 & country==15 & tempo>=ym(2013,10) & tempo<ym(2013,12)
	*Switzerland - 20 (for the 2003,10 reform, composed by two different laws, there were two announcements, one in march 2000, the other in feb 2000)
	replace time_reform_red_pen_A=3 if time_reform_red_pen_A==4 & country==20 & tempo>=ym(2000,2) & tempo<ym(2003,10)
	replace time_reform_red_pen_A=3 if time_reform_red_pen_A==4 & country==20 & tempo>=ym(2006,1) & tempo<ym(2008,12)

	g dist_ann_red_pen=.
	*Austria - 11
	replace dist_ann_red_pen=tempo-ym(2003,3) if timeS_reform_red_pen_A==1 & country==11 & tempo>=ym(2003,3) & tempo<ym(2003,6)
	replace dist_ann_red_pen=tempo-ym(2004,10) if timeS_reform_red_pen_A==1 & country==11 & tempo>=ym(2004,10) & tempo<ym(2004,12)
	replace dist_ann_red_pen=tempo-ym(2010,10) if timeS_reform_red_pen_A==1 & country==11 & tempo>=ym(2010,10) & tempo<ym(2010,12)
	*Denmark - 18
	replace dist_ann_red_pen=tempo-ym(2011,5) if timeS_reform_red_pen_A==1 & country==18 & tempo>=ym(2011,5) & tempo<ym(2011,12)
	*France - 17
	replace dist_ann_red_pen=tempo-ym(2003,1) if timeS_reform_red_pen_A==1 & country==17 & tempo>=ym(2003,1) & tempo<ym(2003,7)
	replace dist_ann_red_pen=tempo-ym(2013,9) if timeS_reform_red_pen_A==1 & country==17 & tempo>=ym(2013,9) & tempo<ym(2014,1)
	*Germany - 12
	replace dist_ann_red_pen=tempo-ym(2003,8) if timeS_reform_red_pen_A==1 & country==12 & tempo>=ym(2003,8) & tempo<ym(2004,6)
	*Italy - 16
	replace dist_ann_red_pen=tempo-ym(2004,1) if timeS_reform_red_pen_A==1 & country==16 & tempo>=ym(2004,1) & tempo<ym(2004,7)
	*Spain - 15
	replace dist_ann_red_pen=tempo-ym(2006,7) if timeS_reform_red_pen_A==1 & country==15 & tempo>=ym(2006,7) & tempo<ym(2007,12)
	replace dist_ann_red_pen=tempo-ym(2011,1) if timeS_reform_red_pen_A==1 & country==15 & tempo>=ym(2011,1) & tempo<ym(2011,8)
	replace dist_ann_red_pen=tempo-ym(2013,10) if timeS_reform_red_pen_A==1 & country==15 & tempo>=ym(2013,10) & tempo<ym(2013,12)
	*Switzerland - 20 (for the 2003,10 reform, composed by two different laws, there were two announcements, one in march 2000, the other in feb 2000)
	replace dist_ann_red_pen=tempo-ym(2000,2) if timeS_reform_red_pen_A==1 & country==20 & tempo>=ym(2000,2) & tempo<ym(2003,10)
	replace dist_ann_red_pen=tempo-ym(2006,1) if time`s'_reform_red_pen_A==2 & country==20 & tempo>=ym(2006,1) & tempo<ym(2008,12)
	

table tempo country, c(mean timeS_reform_age_incr_A)

table tempo country, c(mean timeS_reform_red_pen_A)

save reforms, replace

* Unbundle also I(0,12)
use reforms, clear

g timeS_reform_age_incr_Abis=timeS_reform_age_incr_A
g timeS_reform_red_pen_Abis=timeS_reform_red_pen_A
replace timeS_reform_age_incr_Abis=4 if timeS_reform_age_incr_Abis==3
replace timeS_reform_red_pen_Abis=4 if timeS_reform_red_pen_Abis==3

	*Austria - 11
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==11 & tempo>=ym(2003,6) & tempo<=ym(2003,6)+12
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==11 & tempo>=ym(2004,12) & tempo<=ym(2004,12)+12
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==11 & tempo>=ym(2010,12) & tempo<=ym(2010,12)+12
	*Belgium - 23
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==23 & tempo>=ym(2005,12) & tempo<=ym(2005,12)+12
	*Denmark - 18
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==18 & tempo>=ym(2006,6) & tempo<=ym(2006,6)+12
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==18 & tempo>=ym(2011,12) & tempo<=ym(2011,12)+12
	*France - 17
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==17 & tempo>=ym(2003,7) & tempo<=ym(2003,7)+12
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==17 & tempo>=ym(2010,11) & tempo<=ym(2010,11)+12
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==17 & tempo>=ym(2011,12) & tempo<=ym(2011,12)+12
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==17 & tempo>=ym(2014,1) & tempo<=ym(2014,1)+12
	*Germany - 12
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==12 & tempo>=ym(2007,3) & tempo<=ym(2007,3)+12
	*Italy - 16
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==16 & tempo>=ym(2004,7) & tempo<=ym(2004,7)+12
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==16 & tempo>=ym(2009,7) & tempo<=ym(2009,7)+12
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==16 & tempo>=ym(2010,7) & tempo<=ym(2010,7)+12
	*Netherlands - 14
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==14 & tempo>=ym(2012,7) & tempo<=ym(2012,7)+12
	*Spain - 15
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==15 & tempo>=ym(2007,12) & tempo<=ym(2007,12)+12
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==15 & tempo>=ym(2011,8) & tempo<=ym(2011,8)+12
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==15 & tempo>=ym(2013,12) & tempo<=ym(2013,12)+12
	*Switzerland - 20
	replace timeS_reform_age_incr_Abis=3 if timeS_reform_age_incr_Abis==4 & country==20 & tempo>=ym(2003,10) & tempo<=ym(2003,10)+12

	*Austria - 11
	replace timeS_reform_red_pen_Abis=3 if timeS_reform_red_pen_Abis==4 & country==11 & tempo>=ym(2003,6) & tempo<=ym(2003,6)+12
	replace timeS_reform_red_pen_Abis=3 if timeS_reform_red_pen_Abis==4 & country==11 & tempo>=ym(2004,12) & tempo<=ym(2004,12)+12
	replace timeS_reform_red_pen_Abis=3 if timeS_reform_red_pen_Abis==4 & country==11 & tempo>=ym(2010,12) & tempo<=ym(2010,12)+12
	*Denmark - 18
	replace timeS_reform_red_pen_Abis=3 if timeS_reform_red_pen_Abis==4 & country==18 & tempo>=ym(2011,12) & tempo<=ym(2011,12)+12
	*France - 17
	replace timeS_reform_red_pen_Abis=3 if timeS_reform_red_pen_Abis==4 & country==17 & tempo>=ym(2003,7) & tempo<=ym(2003,7)+12
	replace timeS_reform_red_pen_Abis=3 if timeS_reform_red_pen_Abis==4 & country==17 & tempo>=ym(2014,1) & tempo<=ym(2014,1)+12
	*Germany - 12
	replace timeS_reform_red_pen_Abis=3 if timeS_reform_red_pen_Abis==4 & country==12 & tempo>=ym(2004,6) & tempo<=ym(2004,6)+12
	*Italy - 16
	replace timeS_reform_red_pen_Abis=3 if timeS_reform_red_pen_Abis==4 & country==16 & tempo>=ym(2004,7) & tempo<=ym(2004,7)+12
	*Spain - 15
	replace timeS_reform_red_pen_Abis=3 if timeS_reform_red_pen_Abis==4 & country==15 & tempo>=ym(2007,12) & tempo<=ym(2007,12)+12
	replace timeS_reform_red_pen_Abis=3 if timeS_reform_red_pen_Abis==4 & country==15 & tempo>=ym(2011,8) & tempo<=ym(2011,8)+12
	replace timeS_reform_red_pen_Abis=3 if timeS_reform_red_pen_Abis==4 & country==15 & tempo>=ym(2013,12) & tempo<=ym(2013,12)+12
	*Switzerland - 20 (for the 2003,10 reform, composed by two different laws, there were two announcements, one in march 2000, the other in feb 2000)
	replace timeS_reform_red_pen_Abis=3 if timeS_reform_red_pen_Abis==4 & country==20 & tempo>=ym(2003,10) & tempo<=ym(2003,10)+12
	replace timeS_reform_red_pen_Abis=3 if timeS_reform_red_pen_Abis==4 & country==20 & tempo>=ym(2008,12) & tempo<=ym(2008,12)+12
	
tab timeS_reform_age_incr_Abis
tab timeS_reform_red_pen_Abis
	
save reforms, replace

************************************************
* Dummy announcements
use reforms, clear

g announc_age_incr=0
	*Austria - 11
	replace announc_age_incr=1 if country==11 & tempo>=ym(2003,3) & tempo<=ym(2003,3)+5
	replace announc_age_incr=1 if country==11 & tempo>=ym(2004,10) & tempo<=ym(2004,10)+5
	replace announc_age_incr=1 if country==11 & tempo>=ym(2010,10) & tempo<=ym(2010,10)+5
	*Belgium - 23
	replace announc_age_incr=1 if country==23 & tempo>=ym(2005,10) & tempo<=ym(2005,10)+5
	*Denmark - 18
	replace announc_age_incr=1 if country==18 & tempo>=ym(2006,4) & tempo<=ym(2006,4)+5
	replace announc_age_incr=1 if country==18 & tempo>=ym(2011,5) & tempo<=ym(2011,5)+5
	*France - 17
	replace announc_age_incr=1 if country==17 & tempo>=ym(2003,1) & tempo<=ym(2003,1)+5
	replace announc_age_incr=1 if country==17 & tempo>=ym(2010,6) & tempo<=ym(2010,6)+5
	replace announc_age_incr=1 if country==17 & tempo>=ym(2011,11) & tempo<=ym(2011,11)+5
	replace announc_age_incr=1 if country==17 & tempo>=ym(2013,9) & tempo<=ym(2013,9)+5
	*Germany - 12
	replace announc_age_incr=1 if country==12 & tempo>=ym(2006,11) & tempo<=ym(2006,11)+5
	*Italy - 16
	replace announc_age_incr=1 if country==16 & tempo>=ym(2004,1) & tempo<=ym(2004,1)+5
	replace announc_age_incr=1 if country==16 & tempo>=ym(2008,11) & tempo<=ym(2008,11)+5
	replace announc_age_incr=1 if country==16 & tempo>=ym(2010,6) & tempo<=ym(2010,6)+5
	*Netherlands - 14
	*note: the reform in June 2015 was anticipated by an agreement with social parties in 
	*October 2012. We do not consider it here, but below with the empty announcements
	replace announc_age_incr=1 if country==14 & tempo>=ym(2012,5) & tempo<=ym(2012,5)+5
	*Spain - 15
	replace announc_age_incr=1 if country==15 & tempo>=ym(2006,7) & tempo<=ym(2006,7)+5
	replace announc_age_incr=1 if country==15 & tempo>=ym(2011,1) & tempo<=ym(2011,1)+5
	replace announc_age_incr=1 if country==15 & tempo>=ym(2013,10) & tempo<=ym(2013,10)+5
	*Switzerland - 20
	replace announc_age_incr=1 if country==20 & tempo>=ym(2000,2) & tempo<=ym(2000,2)+5

g announc_red_pen=0
	*Austria - 11
	replace announc_red_pen=1 if country==11 & tempo>=ym(2003,3) & tempo<=ym(2003,3)+5
	replace announc_red_pen=1 if country==11 & tempo>=ym(2004,10) & tempo<=ym(2004,10)+5
	replace announc_red_pen=1 if country==11 & tempo>=ym(2010,10) & tempo<=ym(2010,10)+5
	*Denmark - 18
	replace announc_red_pen=1 if country==18 & tempo>=ym(2011,5) & tempo<=ym(2011,5)+5
	*France - 17
	replace announc_red_pen=1 if country==17 & tempo>=ym(2003,1) & tempo<=ym(2003,1)+5
	replace announc_red_pen=1 if country==17 & tempo>=ym(2013,9) & tempo<=ym(2013,9)+5
	*Germany - 12
	replace announc_red_pen=1 if country==12 & tempo>=ym(2003,8) & tempo<=ym(2003,8)+5
	*Italy - 16
	replace announc_red_pen=1 if country==16 & tempo>=ym(2004,1) & tempo<=ym(2004,1)+5
	*Spain - 15
	replace announc_red_pen=1 if country==15 & tempo>=ym(2006,7) & tempo<=ym(2006,7)+5
	replace announc_red_pen=1 if country==15 & tempo>=ym(2011,1) & tempo<=ym(2011,1)+5
	replace announc_red_pen=1 if country==15 & tempo>=ym(2013,10) & tempo<=ym(2013,10)+5
	*Switzerland - 20 (for the 2003,10 reform, composed by two different laws, there were two announcements, one in march 2000, the other in feb 2000)
	replace announc_red_pen=1 if country==20 & tempo>=ym(2000,2) & tempo<=ym(2000,2)+5
	replace announc_red_pen=1 if country==20 & tempo>=ym(2000,3) & tempo<=ym(2000,3)+5
	replace announc_red_pen=1 if country==20 & tempo>=ym(2006,1) & tempo<=ym(2006,1)+5


g Dannounc_age_incr=0
	*Austria - 11
	replace Dannounc_age_incr=1 if country==11 & tempo==ym(2003,3)
	replace Dannounc_age_incr=1 if country==11 & tempo==ym(2004,10)
	replace Dannounc_age_incr=1 if country==11 & tempo==ym(2010,10)
	*Belgium - 23
	replace Dannounc_age_incr=1 if country==23 & tempo==ym(2005,10)
	*Denmark - 18
	replace Dannounc_age_incr=1 if country==18 & tempo==ym(2006,4)
	replace Dannounc_age_incr=1 if country==18 & tempo==ym(2011,5)
	*France - 17
	replace Dannounc_age_incr=1 if country==17 & tempo==ym(2003,1)
	replace Dannounc_age_incr=1 if country==17 & tempo==ym(2010,6)
	replace Dannounc_age_incr=1 if country==17 & tempo==ym(2011,11)
	replace Dannounc_age_incr=1 if country==17 & tempo==ym(2013,9)
	*Germany - 12
	replace Dannounc_age_incr=1 if country==12 & tempo==ym(2006,11)
	*Italy - 16
	replace Dannounc_age_incr=1 if country==16 & tempo==ym(2004,1)
	replace Dannounc_age_incr=1 if country==16 & tempo==ym(2008,11)
	replace Dannounc_age_incr=1 if country==16 & tempo==ym(2010,6)
	*Netherlands - 14
	*note: the reform in June 2015 was anticipated by an agreement with social parties in 
	*October 2012. We do not consider it here, but below with the empty announcements
	replace Dannounc_age_incr=1 if country==14 & tempo==ym(2012,5)
	*Spain - 15
	replace Dannounc_age_incr=1 if country==15 & tempo==ym(2006,7)
	replace Dannounc_age_incr=1 if country==15 & tempo==ym(2011,1)
	replace Dannounc_age_incr=1 if country==15 & tempo==ym(2013,10)
	*Switzerland - 20
	replace Dannounc_age_incr=1 if country==20 & tempo==ym(2000,2)

g Dannounc_red_pen=0
	*Austria - 11
	replace Dannounc_red_pen=1 if country==11 & tempo==ym(2003,3)
	replace Dannounc_red_pen=1 if country==11 & tempo==ym(2004,10)
	replace Dannounc_red_pen=1 if country==11 & tempo==ym(2010,10)
	*Denmark - 18
	replace Dannounc_red_pen=1 if country==18 & tempo==ym(2011,5)
	*France - 17
	replace Dannounc_red_pen=1 if country==17 & tempo==ym(2003,1)
	replace Dannounc_red_pen=1 if country==17 & tempo==ym(2013,9)
	*Germany - 12
	replace Dannounc_red_pen=1 if country==12 & tempo==ym(2003,8)
	*Italy - 16
	replace Dannounc_red_pen=1 if country==16 & tempo==ym(2004,1)
	*Spain - 15
	replace Dannounc_red_pen=1 if country==15 & tempo==ym(2006,7)
	replace Dannounc_red_pen=1 if country==15 & tempo==ym(2011,1)
	replace Dannounc_red_pen=1 if country==15 & tempo==ym(2013,10)
	*Switzerland - 20 (for the 2003,10 reform, composed by two different laws, there were two announcements, one in march 2000, the other in feb 2000)
	replace Dannounc_red_pen=1 if country==20 & tempo==ym(2000,2)
	replace Dannounc_red_pen=1 if country==20 & tempo==ym(2000,3)
	replace Dannounc_red_pen=1 if country==20 & tempo==ym(2006,1)
	
g D3announc_age_incr=0
	*Austria - 11
	replace D3announc_age_incr=1 if country==11-1 & tempo>=ym(2003,3)-1 & tempo<=ym(2003,3)+1
	replace D3announc_age_incr=1 if country==11-1 & tempo>=ym(2004,10)-1 & tempo<=ym(2004,10)+1
	replace D3announc_age_incr=1 if country==11-1 & tempo>=ym(2010,10)-1 & tempo<=ym(2010,10)+1
	*Belgium - 23
	replace D3announc_age_incr=1 if country==23-1 & tempo>=ym(2005,10)-1 & tempo<=ym(2005,10)+1
	*Denmark - 18
	replace D3announc_age_incr=1 if country==18-1 & tempo>=ym(2006,4)-1 & tempo<=ym(2006,4)+1
	replace D3announc_age_incr=1 if country==18-1 & tempo>=ym(2011,5)-1 & tempo<=ym(2011,5)+1
	*France - 17
	replace D3announc_age_incr=1 if country==17-1 & tempo>=ym(2003,1)-1 & tempo<=ym(2003,1)+1
	replace D3announc_age_incr=1 if country==17-1 & tempo>=ym(2010,6)-1 & tempo<=ym(2010,6)+1
	replace D3announc_age_incr=1 if country==17-1 & tempo>=ym(2011,11)-1 & tempo<=ym(2011,11)+1
	replace D3announc_age_incr=1 if country==17-1 & tempo>=ym(2013,9)-1 & tempo<=ym(2013,9)+1
	*Germany - 12
	replace D3announc_age_incr=1 if country==12-1 & tempo>=ym(2006,11)-1 & tempo<=ym(2006,11)+1
	*Italy - 16
	replace D3announc_age_incr=1 if country==16-1 & tempo>=ym(2004,1)-1 & tempo<=ym(2004,1)+1
	replace D3announc_age_incr=1 if country==16-1 & tempo>=ym(2008,11)-1 & tempo<=ym(2008,11)+1
	replace D3announc_age_incr=1 if country==16-1 & tempo>=ym(2010,6)-1 & tempo<=ym(2010,6)+1
	*Netherlands - 14
	*note: the reform in June 2015 was anticipated by an agreement with social parties in 
	*October 2012. We do not consider it here, but below with the empty announcements
	replace D3announc_age_incr=1 if country==14-1 & tempo>=ym(2012,5)-1 & tempo<=ym(2012,5)+1
	*Spain - 15
	replace D3announc_age_incr=1 if country==15-1 & tempo>=ym(2006,7)-1 & tempo<=ym(2006,7)+1
	replace D3announc_age_incr=1 if country==15-1 & tempo>=ym(2011,1)-1 & tempo<=ym(2011,1)+1
	replace D3announc_age_incr=1 if country==15-1 & tempo>=ym(2013,10)-1 & tempo<=ym(2013,10)+1
	*Switzerland - 20
	replace D3announc_age_incr=1 if country==20-1 & tempo>=ym(2000,2)-1 & tempo<=ym(2000,2)+1

g D3announc_red_pen=0
	*Austria - 11
	replace D3announc_red_pen=1 if country==11-1 & tempo>=ym(2003,3)-1 & tempo<=ym(2003,3)+1
	replace D3announc_red_pen=1 if country==11-1 & tempo>=ym(2004,10)-1 & tempo<=ym(2004,10)+1
	replace D3announc_red_pen=1 if country==11-1 & tempo>=ym(2010,10)-1 & tempo<=ym(2010,10)+1
	*Denmark - 18
	replace D3announc_red_pen=1 if country==18-1 & tempo>=ym(2011,5)-1 & tempo<=ym(2011,5)+1
	*France - 17
	replace D3announc_red_pen=1 if country==17-1 & tempo>=ym(2003,1)-1 & tempo<=ym(2003,1)+1
	replace D3announc_red_pen=1 if country==17-1 & tempo>=ym(2013,9)-1 & tempo<=ym(2013,9)+1
	*Germany - 12
	replace D3announc_red_pen=1 if country==12-1 & tempo>=ym(2003,8)-1 & tempo<=ym(2003,8)+1
	*Italy - 16
	replace D3announc_red_pen=1 if country==16-1 & tempo>=ym(2004,1)-1 & tempo<=ym(2004,1)+1
	*Spain - 15
	replace D3announc_red_pen=1 if country==15-1 & tempo>=ym(2006,7)-1 & tempo<=ym(2006,7)+1
	replace D3announc_red_pen=1 if country==15-1 & tempo>=ym(2011,1)-1 & tempo<=ym(2011,1)+1
	replace D3announc_red_pen=1 if country==15-1 & tempo>=ym(2013,10)-1 & tempo<=ym(2013,10)+1
	*Switzerland - 20 (for the 2003,10 reform, composed by two different laws, there were two announcements, one in march 2000, the other in feb 2000)
	replace D3announc_red_pen=1 if country==20-1 & tempo>=ym(2000,2)-1 & tempo<=ym(2000,2)+1
	replace D3announc_red_pen=1 if country==20-1 & tempo>=ym(2000,3)-1 & tempo<=ym(2000,3)+1
	replace D3announc_red_pen=1 if country==20-1 & tempo>=ym(2006,1)-1 & tempo<=ym(2006,1)+1
	
save reforms, replace
 
************************************************
* I add other important annoucements without reform or far from reform

* Announced not realized
*Belgium-23 2004,October:A 2008,November:A+B
*France-17 2008,April:A+B 2011,March:A+B
*Netherlands-14 2003,September:B 2004,November:B 2010,June:A 2011,October:A 
*Spain-15 2008,April:A+B
*Switzerland-20 2002,April:B 2014,November:A+B 2015,September:A+B
*Sweden-13 2013-April:A

* Announcements of reforms realized much later
*Germany-12 2003,8:A (realized in March 2007)
*Netherlands-14 2012,October:A (realized in June 2015)

use reforms, clear
g emptann_age_incr=0
replace emptann_age_incr=1 if country==12 & tempo>=ym(2003,8) & tempo<=ym(2003,8)+5
replace emptann_age_incr=1 if country==23 & tempo>=ym(2004,10) & tempo<=ym(2004,10)+5
replace emptann_age_incr=1 if country==23 & tempo>=ym(2008,11) & tempo<=ym(2008,11)+5
replace emptann_age_incr=1 if country==17 & tempo>=ym(2008,4) & tempo<=ym(2008,4)+5
replace emptann_age_incr=1 if country==17 & tempo>=ym(2011,3) & tempo<=ym(2011,3)+5
replace emptann_age_incr=1 if country==14 & tempo>=ym(2010,6) & tempo<=ym(2010,6)+5
replace emptann_age_incr=1 if country==14 & tempo>=ym(2011,10) & tempo<=ym(2011,10)+5
replace emptann_age_incr=1 if country==14 & tempo>=ym(2012,10) & tempo<=ym(2012,10)+5
replace emptann_age_incr=1 if country==15 & tempo>=ym(2008,4) & tempo<=ym(2008,4)+5
replace emptann_age_incr=1 if country==20 & tempo>=ym(2014,11) & tempo<=ym(2014,11)+5
replace emptann_age_incr=1 if country==20 & tempo>=ym(2015,9) & tempo<=ym(2015,9)+5
replace emptann_age_incr=1 if country==13 & tempo>=ym(2013,4) & tempo<=ym(2013,4)+5

g emptann_red_pen=0
replace emptann_red_pen=1 if country==23 & tempo>=ym(2008,11) & tempo<=ym(2008,11)+5
replace emptann_red_pen=1 if country==17 & tempo>=ym(2008,4) & tempo<=ym(2008,4)+5
replace emptann_red_pen=1 if country==17 & tempo>=ym(2011,3) & tempo<=ym(2011,3)+5
replace emptann_red_pen=1 if country==14 & tempo>=ym(2003,9) & tempo<=ym(2003,9)+5
replace emptann_red_pen=1 if country==14 & tempo>=ym(2004,11) & tempo<=ym(2004,11)+5
replace emptann_red_pen=1 if country==15 & tempo>=ym(2008,4) & tempo<=ym(2008,4)+5
replace emptann_red_pen=1 if country==20 & tempo>=ym(2002,4) & tempo<=ym(2002,4)+5
replace emptann_red_pen=1 if country==20 & tempo>=ym(2014,11) & tempo<=ym(2014,11)+5
replace emptann_red_pen=1 if country==20 & tempo>=ym(2015,9) & tempo<=ym(2015,9)+5

save reforms, replace

***********************************************************
* NEXIS
***********************************************************
use reforms, clear

merge m:1 country tempo using "$input_ext/news_nexis"
drop if _merge==2
tab country _merge
tab int_year _merge
count
drop _merge
save reforms, replace